#
# Copyright (C) 2006 by Victor Julien <victor@inliniac.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
# Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

#
# Object for parsing ModSecurity autitlog event files.
#

package ModsecAlert;

use fields qw (	store );

sub new {
	my $type = shift;
	my ModsecAlert $self = fields::new(ref $type || $type);

	$self->{store} = undef;

	return $self;
}

#
# Returns a COPY of the alert hash
#
sub getalerthash {
	my ModsecAlert $self = shift;

	return $self->{store};
}

#
# Takes the location of a file as argument, 
# open it, parses it and stores it into
# the $self->{store} hash.
#
sub parsefile {
	my ModsecAlert $self = shift;
	my $filename = shift;

        my $line_num = 1;
        my $fileid;
        my $section = "-";
        my %event;

        # initialize some vars in case the alert doesn't contain them
        $self->{store}{"file"} = "";
        $self->{store}{"severity"} = "DEBUG"; # lowest by modsec
        $self->{store}->{"rev"} = 0;

        open (FILE , $filename) or die "Could not open file $filename: $!\n";

        while(<FILE>)
        {
                # store all lines of the file so we can use it
                # as the alert payload later
                $self->{store}{"file"} = $self->{store}{"file"} . $_;

                # Get this file's unique id
                if($line_num == 1)
                {
                        my @parsed_line = /^--(\S+)-A--$/;
                        if ( @parsed_line == 0 ) {
                                goto error;
                        } else {
                                #print "parsed line @parsed_line\n";

                                ( $fileid ) = @parsed_line;
                                #print "fileid " . $fileid . "\n";
                        }
                }	
                # parse the section character
                if ( /^--$fileid-\S+--$/ ) {
                        my @parsed_line = /^--$fileid-(\S+)--$/;
                        ( $section ) = @parsed_line;
                        #print "section " . $section . "\n";
                }

                #section A -- time, ipaddresses and ports
                if($section eq "A")
                {
                        if(m/^\[.*\] .*$/) {
                                my @parsed_line = /^\[(\d+)\/(\S+)\/(\d+):(.*) (.*)\] (\S+) (\S+) (\d+) (\S+) (\d+)$/;
                                if ( @parsed_line == 0 ) {
                                        goto error;
                                } else {
                                        ( $self->{store}{"day"}, $self->{store}{"monthstr"}, $self->{store}{"year"},
                                          $self->{store}{"timestr"}, $self->{store}{"tz"}, $self->{store}{"uniqueid"},
                                          $self->{store}{"sipstr"}, $self->{store}{"sp"}, $self->{store}{"dipstr"},
                                          $self->{store}{"dp"} ) = @parsed_line;

                                        # all further processing is done only if we know this
                                        # is an alert. PreprocessAlert processes it further.
                                }
                        }
                }
                #section H, alert info, mod_sec response
                if ( $section eq "H" )
                {
                        if ( m/^Message\: Access denied with code.*/ )
                        {
                                my @parsed_line = /^Message\: Access denied with code (\d+)\. (.*) \[severity \"(\S+)\"\]$/;
                                if ( @parsed_line == 0 )
                                {
                                        goto error;
                                }
                                else
                                {
                                        ( $self->{store}{"code"} , $self->{store}{"themsg"} , $self->{store}{"severity"} ) = @parsed_line;
                                }
                        }
                        elsif ( m/^Message\: Access denied with redirect to.*/ )
                        {
                                my @parsed_line = /^Message\: Access denied with redirect to \[(.*)\]\. (.*) \[severity \"(\S+)\"\]$/;
                                if ( @parsed_line == 0 )
                                {
                                        goto error;
                                }
                                else
                                {
                                        ( $self->{store}{"redirecturl"} , $self->{store}{"themsg"} , $self->{store}{"severity"} ) = @parsed_line;
                                }
                        }

                        # if we do not yet have a code (e.g. in a redirect case)
                        # we try to find it here
                        if(not defined($self->{store}{"code"}) )
                        {
                                if(m/^Action\: Intercepted \((\d+)\).*/)
                                {
                                        my @parsed_line = /^Action\: Intercepted \((\d+)\)$/;
                                        if ( @parsed_line == 0 )
                                        {
                                                goto error;
                                        }
                                        else
                                        {
                                                ( my $code ) = @parsed_line;
                                                #print "Action " . $code . "\n";
                                                $self->{store}{"code"} = $code;
                                        }
                                }
                        }
                }
                $line_num++;
        }

        close(FILE);
        return;

        # a bit ugly, but it saves us from duplicating a lot of code:
        # close file, chomp, print error, return -1.
error:
        close(FILE);
        chomp();
        die "Error parsing line $line_num: $_";
}

1;

